import theater.*;

import java.awt.Color;


/**
 * Uebernommen aus dem Greenfoot-Szenario asteroids.
 * <p>
 * </p>
 * ... the final frontier
 */
public class Space extends Stage {
    public Space() {
        super(600, 400, 1);
        setBackground(new TheaterImage(600, 400));
        getBackground().setColor(Color.BLACK);
        getBackground().fill();
        createStars(300);

        add(new Rocket(), 300, 200);
        add(new Asteroid(), 100, 100);
        add(new Asteroid(), 500, 300);
    }

    private void createStars(int number) {
        TheaterImage background = getBackground();

        for (int i = 0; i < number; i++) {
            int x = (int) (Math.random() * getNumberOfColumns());
            int y = (int) (Math.random() * getNumberOfRows());
            int color = 100 - (int) (Math.random() * 80);
            background.setColor(new Color(color, color, color));
            background.fillOval(x, y, 1, 1);
        }
    }
}
