import theater.*;

import java.util.List;


/**
 * bertragen aus dem Greenfoot-Szenario balloons
 * <p>
 * </p>
 * A world of balloons.
 *
 * Balloons will be created and flow from the bottom to the top of the screen.
 */
public class BalloonWorld extends Stage {
    Counter counter = new Counter("Score: ");
    Dart dart;
    Bomb bomb = null;

    /**
     * Constructor for objects of class MyWorld.
     *
     */
    public BalloonWorld() {
        super(800, 600, 1);
        setBackground("bricks2.gif");

        // Make sure actors are painted in the correct order.
        // setPaintOrder(ScoreBoard.class, Explosion.class, Bomb.class,
        // Dart.class, Balloon.class, Counter.class);

        // Add the initial actors
        populate();
    }

    /**
     * Creates balloons at the bottom of the world.
     */
    public void run() {
        if (new java.util.Random().nextInt(100) < 3) {
            add(new Balloon(), new java.util.Random().nextInt(700), 600);
        }
    }

    /**
     * Count one popped balloon.
     */
    public void countPop() {
        counter.add(20);
    }

    /**
     * Called when game is up. Stop running and display score.
     */
    public void gameOver() {
        add(new ScoreBoard(counter.getValue()), getNumberOfColumns() / 2,
            getNumberOfRows() / 2);
        Performance.getPerformance().playSound("buzz.wav");
        Performance.getPerformance().stop();
    }

    /**
     * Populate the world with bombs and a crosshair.
     */
    private void populate() {
        add(new Bomb(), 750, 410);
        add(new Bomb(), 750, 480);
        add(new Bomb(), 750, 550);
        add(dart = new Dart(), 400, 300);

        add(counter, 100, 560);
    }

    public void mouseMoved(MouseInfo info) {
        dart.setLocation(info.getColumn(), info.getRow());
    }

    public void mousePressed(MouseInfo info) {
        // Pop
        int col = dart.getColumn();
        int row = dart.getRow();
        col = col - (dart.getImage().getWidth() / 2);
        row = row + (dart.getImage().getHeight() / 2);

        Point p = new Point(col, row); // Dartspitze
        List<Component> balloons = getIntersectingComponents(p, Balloon.class);

        for (Component balloon : balloons) {
            ((Balloon) balloon).pop();
        }

        // Bomb
        p = new Point(info.getColumn(), info.getRow());

        List<Component> bombs = getIntersectingComponents(p, Bomb.class);

        if (bombs.size() == 0) {
            return;
        }

        bomb = (Bomb) bombs.get(0);
    }

    public void mouseDragged(MouseInfo info) {
        if (bomb == null) {
            return;
        }

        bomb.setLocation(info.getColumn(), info.getRow());
    }

    public void mouseReleased(MouseInfo info) {
        if (bomb == null) {
            return;
        }

        bomb.setLocation(info.getColumn(), info.getRow());

        if (getIntersectingComponents(bomb, Balloon.class).size() > 0) {
            bomb.explode();
        } else {
            bomb.reset();
        }
        bomb = null;
    }
}
