import theater.*;
import java.util.List;

/**
 * bertragen aus dem Greenfoot-Szenario balloons
 * <p>
 * </p>
 * A bomb can be used to explode balloons. It will make an explosion that pops
 * all the balloons that it touches.
 * <p>
 * 
 * The bombs are used by dragging them from their initial location and onto a
 * balloon. This will trigger the explosion. If the balloon is dragged to a
 * location with out a balloon it will return the bomb to its original location.
 */
public class Bomb extends Actor {
	// The initial location of the bomb
	private int originalX;
	private int originalY;
	
	public Bomb() {
	    setImage("bomb_01.png");
	    setZCoordinate(2);
	}

	/**
	 * Will store the initial location of the bomb.
	 */
	public void addedToStage(Stage stage) {
		originalX = getColumn();
		originalY = getRow();
	}

	/**
	 * Make an explosion.
	 */
	public void explode() {
		List<Component> balloons = getStage().getComponents(Balloon.class);

		getStage().add(new Explosion(), getColumn(), getRow());
		getStage().remove(this);
	}

	/**
	 * Reset the bomb to its original location.
	 */
	public void reset() {
		setLocation(originalX, originalY);
	}
}
