import theater.*;

import java.awt.Color;
import java.awt.Font;


public class Button extends Prop {
    String info;
    int numbers;
    Color color;

    public Button(String info, int numbers, Color color) {
        this.info = info;
        this.numbers = numbers;
        this.color = color;
        createAndSetImage();
    }

    private void createAndSetImage() {
        TheaterImage image = new TheaterImage(140, 80);
        image.setColor(new Color(200, 200, 200, 50));
        image.fillRect(0, 0, 120, 60);
        image.setColor(this.color);

        Font font = image.getFont();
        image.setFont(font.deriveFont(24.0f));
        image.drawRect(0, 0, 120, 60);
        image.drawString(numbers + " " + info, 10, 40);
        setImage(image);
    }

    public void mousePressed(MouseInfo event) {
        ((CurvesWorld) getStage()).finishChoice(numbers);
    }
}
