import theater.*;

import java.awt.Color;
import java.awt.Font;


public class CountDown extends Actor {
    private int number;
    private TheaterImage image;
    Clock clock;
    boolean ready;

    public CountDown(int start) {
        this.number = start;
        image = new TheaterImage(140, 160);
        image.setColor(Color.RED);

        Font font = image.getFont();
        image.setFont(font.deriveFont(96.0f));
        setImage(image);
        updateImage();
    }

    public void addedToStage(Stage stage) {
        clock = new Clock(1000);
        ready = false;
    }

    private void updateImage() {
        image.clear();
        image.drawString("" + number, 10, 80);
    }

    public void run() {
        if (ready) {
            return;
        }

        if (clock.isNull()) {
            this.number--;

            if (number <= 0) {
                ready = true;
                ((CurvesWorld) getStage()).countDownFinished();

                return;
            }

            updateImage();
            clock = new Clock(1000);
        }
    }
}
