import theater.*;

import java.awt.Font;


public class Points extends Prop {
    Player player;
    TheaterImage image;

    public Points(Player player) {
        this.player = player;
        image = new TheaterImage(80, 80);
        image.setColor(player.getColor());

        Font font = image.getFont();
        image.setFont(font.deriveFont(24.0f));
        setImage(image);
        update();
    }

    void update() {
        image.clear();
        image.drawString("" + player.getPoints(), 10, 40);
    }
}
