import theater.*;

import java.util.List;


/**
 * Repraesentation von Koernern im Java-Hamster-Modell
 *
 * @author Dietrich Boles (Universitaet Oldenburg)
 * @version 2.0 (07.06.2008)
 *
 */
public class Korn extends Prop {
    private int anzahl;

    public Korn() {
        this(1);
    }

    public Korn(int anzahl) {
        setImage("korn.png");
        this.anzahl = anzahl;
    }

    // wird aufgerufen, wenn das Korn in das Territorium platziert wird
    public void addedToStage(Stage stage) {
        // Wenn auf der Kachel schon eine Mauer ist, wird das Korn wieder
        // entfernt
        List<Component> mauer = this.getStage()
                                    .getComponentsAt(this.getColumn(),
                this.getRow(), Mauer.class);

        if (mauer.size() > 0) {
            this.getStage().remove(this);

            return;
        }

        // bereits Korn auf Kachel?
        List<Component> koerner = this.getStage()
                                      .getComponentsAt(this.getColumn(),
                this.getRow(), Korn.class);

        if (koerner.size() > 1) {
            Korn korn = (Korn) koerner.get(0);

            if (korn == this) {
                korn = (Korn) koerner.get(1);
            }

            this.getStage().remove(korn);
            this.anzahl += korn.anzahl;
        }

        this.setImage("korn" + Math.min(this.anzahl, 12) + ".png");

        // es werden maximal 12 Koerner angezeigt
    }

    // liefert die Information, das wie vielte Korn dieses Korn auf der Kachel
    // ist
    protected int getAnzahl() {
        return this.anzahl;
    }

    public void setLocation(int col, int row) {
        if ((this.getColumn() == col) && (this.getRow() == row)) {
            return;
        }

        // Mauer auf Kachel?
        if (this.getStage().getComponentsAt(col, row, Mauer.class).size() > 0) {
            return;
        }

        // bereits Korn auf Kachel?
        List<Component> koerner = this.getStage()
                                      .getComponentsAt(col, row, Korn.class);

        if (koerner.size() > 0) {
            Korn korn = (Korn) koerner.get(0);
            this.getStage().remove(korn);
            this.anzahl += korn.anzahl;
            this.setImage("korn" + Math.min(this.anzahl, 12) + ".png");
        }

        super.setLocation(col, row);
    }

    void inkAnzahl(int n) {
        this.anzahl += n;

        if (this.anzahl <= 0) {
            this.getStage().remove(this);
        } else {
            this.setImage("korn" + Math.min(this.anzahl, 12) + ".png");
        }
    }
}
