import theater.*;

import java.util.List;


/**
 * Repraesentation von Mauern im Java-Hamster-Modell
 *
 * @author Dietrich Boles (Universitaet Oldenburg)
 * @version 2.0 (07.06.2008)
 *
 */
public class Mauer extends Prop {
    public Mauer() {
        this.setImage("mauer.png");
    }

    public void addedToStage(Stage stage) {
        this.removeComponentsOnCell(this.getColumn(), this.getRow());
    }

    public void setLocation(int col, int row) {
        if ((this.getColumn() == col) && (this.getRow() == row)) {
            return;
        }

        this.removeComponentsOnCell(col, row);
        super.setLocation(col, row);
    }

    private void removeComponentsOnCell(int x, int y) {
        List<Component> comps = this.getStage().getComponentsAt(x, y);

        for (Component comp : comps) {
            if (comp != this) {
                this.getStage().remove(comp);
            }
        }
    }
}
