/**
 * class representing complex numbers (see
 * http://en.wikipedia.org/wiki/Complex_number)
 *
 * @author Dietrich Boles, University of Oldenburg
 * @version 1.0 (29.10.2008)
 *
 */
public class Complex {
    private double realPart;
    private double imaginaryPart;

    public Complex() {
        this(0.0, 0.0);
    }

    public Complex(double re, double imag) {
        this.realPart = re;
        this.imaginaryPart = imag;
    }

    public Complex(Complex compl) {
        this(compl.realPart, compl.imaginaryPart);
    }

    protected Complex clone() {
        return new Complex(this);
    }

    public boolean equals(Object compl) {
        return (this.realPart == ((Complex) compl).realPart) &&
        (this.imaginaryPart == ((Complex) compl).imaginaryPart);
    }

    public String toString() {
        return this.realPart + " + " + this.imaginaryPart + "i";
    }

    public double getRealPart() {
        return this.realPart;
    }

    public double getImaginaryPart() {
        return this.imaginaryPart;
    }

    public static Complex add(Complex compl1, Complex compl2) {
        return new Complex(compl1.realPart + compl2.realPart,
            compl1.imaginaryPart + compl2.imaginaryPart);
    }

    public Complex add(Complex compl) {
        this.realPart = this.realPart + compl.realPart;
        this.imaginaryPart = this.imaginaryPart + compl.imaginaryPart;

        return this;
    }

    public static Complex mult(Complex compl1, Complex compl2) {
        return new Complex((compl1.realPart * compl2.realPart) -
            (compl1.imaginaryPart * compl2.imaginaryPart),
            (compl1.realPart * compl2.imaginaryPart) +
            (compl1.imaginaryPart * compl2.realPart));
    }

    public Complex mult(Complex compl) {
        Complex tmp = Complex.mult(this, compl);
        this.realPart = tmp.realPart;
        this.imaginaryPart = tmp.imaginaryPart;

        return this;
    }
}
