import theater.Actor;
import theater.KeyInfo;
import theater.Performance;

import java.util.ArrayList;

//uebernommen aus dem Greenfoot-Szenario piano
public class Key extends Actor {
	private String key;
	private String sound;
	private String upImage;
	private String downImage;
	private boolean pressed;

	/**
	 * Create the key and set the sound file that has the note for this key.
	 */
	public Key(String key, String soundFile, String img1, String img2) {
		sound = soundFile;
		this.key = key;
		upImage = img1;
		downImage = img2;
		pressed = false;
	}

	public void run() {
		// nothing to do, see keyPressed and keyReleased
	}

	public void play() {
		Performance.getPerformance().playSound(sound);
	}

	public void keyPressed(KeyInfo info) {
		if (!pressed && this.key.charAt(0) == info.getKeyChar()) {
			play();
			setImage(downImage);
			pressed = true;
		}
	}

	public void keyReleased(KeyInfo info) {
		if (this.key.charAt(0) == info.getKeyChar()) {
			setImage(upImage);
			pressed = false;
		}
	}
}
