import theater.*;
import java.util.HashMap;

// uebernommen aus dem Greenfoot-Szenario piano
public class Piano extends Actor {
	private static final int NUMBER_WHITE_KEYS = 12;
	private static final String[] whiteNotes = { "3c", "3d", "3e", "3f", "3g",
			"3a", "3h", "4c", "4d", "4e", "4f", "4g" };
	private static final String[] whiteKeys = { "a", "s", "d", "f", "g", "h",
			"j", "k", "l", "", "", "#" };

	private static final String[] blackNotes = { "3c#", "3d#", "", "3f#",
			"3g#", "3b", "", "4c#", "4d#", "", "4f#" };
	private static final String[] blackKeys = { "w", "e", "", "t", "z", "u",
			"", "o", "p", "", "" };

	public Piano() {
		TheaterImage image = new TheaterImage(300, 20);
		image.drawString("Click 'Run', then use your keyboard to play", 10, 16);
		setImage(image);
	}

	public void addedToStage(Stage stage) {
		makeKeys();
	}

	public void run() {
		// nothing to do
	}

	/**
	 * Create the piano keys (white and black) and place then in the world.
	 */
	private void makeKeys() {
		// make the white keys
		for (int i = 0; i < NUMBER_WHITE_KEYS; i++) {
			Key key = new WhiteKey(whiteKeys[i], whiteNotes[i] + ".wav");
			getStage().add(key, 54 + (i * 63), 150);
		}

		// make the black keys
		for (int i = 0; i < NUMBER_WHITE_KEYS - 1; i++) {
			if (i % 7 != 2 && i % 7 != 6) {
				Key key = new BlackKey(blackKeys[i], blackNotes[i] + ".wav");
				getStage().add(key, 85 + (i * 63), 96);
			}
		}
	}
}
