import theater.*;

import java.awt.Color;
import java.awt.Font;

public class Info extends Prop {

	private String winner, matter;
	private Color color;

	public Info(String winner, String matter, Color color) {
		this.winner = winner;
		this.matter = matter;
		this.color = color;
	}

	public void addedToStage(Stage stage) {
		makeImage();
	}

	private void makeImage() {
		int WIDTH = (getStage().getNumberOfColumns() - 2)
				* getStage().getCellSize();
		int HEIGHT = (getStage().getNumberOfRows() - 5)
				* getStage().getCellSize();
		TheaterImage image = new TheaterImage(WIDTH, HEIGHT);

		image.setColor(new Color(0, 0, 0, 100));
		image.fillRect(0, 0, WIDTH, HEIGHT);
		image.setColor(new Color(255, 255, 255, 160));
		image.fillRect(5, 5, WIDTH - 10, HEIGHT - 10);
		image.setColor(color);
		Font font = new Font("Monospaced", Font.BOLD, 24);
		image.setFont(font);
		image.drawString(winner, image.getWidth() / 2
				- (int) (winner.length() / 2.0 * 14.0), HEIGHT / 3);
		font = new Font("Monospaced", Font.BOLD, 18);
		image.setFont(font);
		image.drawString(matter, image.getWidth() / 2
				- (int) (matter.length() / 2.0 * 11.0), 2 * HEIGHT / 3);
		setImage(image);
	}
}
