import theater.*;

import java.awt.Color;
import java.awt.Font;


/**
 * Counter that displays a number with a text prefix.
 *
 * @author Dietrich Boles (University of Oldenburg, Germany)
 * @version 1.0 (17.12.2008)
 */
public class Counter extends Prop {
    private static final Color textColor = new Color(0, 0, 0);
    private int value = 0;
    private String text;

    public Counter() {
        this("");
    }

    public Counter(String prefix) {
        text = prefix;
    }

    public void addedToStage(Stage stage) {
        TheaterImage image = new TheaterImage(stage.getNumberOfColumns() * stage.getCellSize(),
                stage.getCellSize() * 2);
        setImage(image);
        image.setColor(textColor);

        Font font = image.getFont();
        font = font.deriveFont(24.0f);
        image.setFont(font);
        updateImage();
    }

    public void add(int points) {
        value += points;
        updateImage();
    }

    public void subtract(int points) {
        value -= points;
        updateImage();
    }

    public int getValue() {
        return value;
    }

    /**
     * Make the image
     */
    private void updateImage() {
        TheaterImage image = getImage();
        image.clear();
        image.drawString(text + value, 10, 20);
    }
}
