import theater.*;


/**
 * represents a L tetromino
 *
 * @author Dietrich Boles (University of Oldenburg, Germany)
 * @version 1.0 (17.12.2008)
 *
 */
public class LTetromino extends Tetromino {
    LTetromino() {
        super("magenta");
    }

    public void addedToStage(Stage stage) {
        direction = genDirection();

        int start = genStartX();
        getStage().add(b[0], start + 2, 0);
        getStage().add(b[1], start + 2, 1);
        getStage().add(b[2], start + 1, 1);
        getStage().add(b[3], start, 1);
        setDirection();
    }

    protected void setDirection() {
        switch (direction) {
        case NORTH:
            b[0].setLocation(b[2].getColumn() + 1, b[2].getRow() + 1);
            b[1].setLocation(b[2].getColumn(), b[2].getRow() + 1);
            b[3].setLocation(b[2].getColumn(), b[2].getRow() - 1);

            break;

        case WEST:
            b[0].setLocation(b[2].getColumn() + 1, b[2].getRow() - 1);
            b[1].setLocation(b[2].getColumn() + 1, b[2].getRow());
            b[3].setLocation(b[2].getColumn() - 1, b[2].getRow());

            break;

        case SOUTH:
            b[0].setLocation(b[2].getColumn() - 1, b[2].getRow() - 1);
            b[1].setLocation(b[2].getColumn(), b[2].getRow() - 1);
            b[3].setLocation(b[2].getColumn(), b[2].getRow() + 1);

            break;

        case EAST:
            b[0].setLocation(b[2].getColumn() - 1, b[2].getRow() + 1);
            b[1].setLocation(b[2].getColumn() - 1, b[2].getRow());
            b[3].setLocation(b[2].getColumn() + 1, b[2].getRow());

            break;
        }
    }

    protected Block leftMost() {
        switch (direction) {
        case NORTH:
            return b[2];

        case WEST:
            return b[3];

        case SOUTH:
            return b[0];

        default: // case EAST:

            return b[0];
        }
    }

    protected Block rightMost() {
        switch (direction) {
        case NORTH:
            return b[0];

        case WEST:
            return b[0];

        case SOUTH:
            return b[1];

        default: // case EAST:

            return b[3];
        }
    }

    protected boolean turnPossible() {
        TetrisWorld world = TetrisWorld.getWorld();

        switch (direction) {
        case NORTH:
            return b[2].getColumn() >= 1;

        case WEST:
            return b[2].getRow() < (world.getNumberOfRows() - 3);

        case SOUTH:
            return b[2].getColumn() < (world.getNumberOfColumns() - 1);

        default: // case EAST:

            return true;
        }
    }

    protected int genStartX() {
        return (int) (Math.random() * (TetrisWorld.getWorld()
                                                  .getNumberOfColumns() - 2));
    }
}
