import theater.Stage;


/**
 * represents a O tetromino
 *
 * @author Dietrich Boles (University of Oldenburg, Germany)
 * @version 1.0 (17.12.2008)
 *
 */
public class OTetromino extends Tetromino {
    OTetromino() {
        super("blue");
    }

    public void addedToStage(Stage stage) {
        direction = NORTH;

        int start = genStartX();
        getStage().add(b[0], start, 0);
        getStage().add(b[1], start + 1, 0);
        getStage().add(b[2], start, 1);
        getStage().add(b[3], start + 1, 1);
    }

    protected void setDirection() {
    }

    protected boolean turnPossible() {
        return false;
    }

    protected Block leftMost() {
        return b[0];
    }

    protected Block rightMost() {
        return b[1];
    }

    protected int genStartX() {
        return (int) (Math.random() * (TetrisWorld.getWorld()
                                                  .getNumberOfColumns() - 1));
    }
}
