import theater.*;

import java.awt.Color;
import java.awt.Font;


/**
 * The ScoreBoard is used to display results on the screen. It can display some
 * text and several numbers.
 *
 * @author Dietrich Boles (University of Oldenburg, Germany)
 * @version 1.0 (17.12.2008)
 */
public class ScoreBoard extends Prop {
    public static final float FONT_SIZE = 24.0f;
    private int score;

    /**
     * Create a score board for the final result.
     */
    public ScoreBoard(int score) {
        this.score = score;
    }

    public void addedToStage(Stage stage) {
        makeImage("Game Over", "Score: ", score);
    }

    /**
     * Make the score board image.
     */
    private void makeImage(String title, String prefix, int score) {
        int WIDTH = (getStage().getNumberOfColumns() + 2) * getStage()
                                                                .getCellSize();
        int HEIGHT = WIDTH;
        TheaterImage image = new TheaterImage(WIDTH, HEIGHT);

        image.setColor(new Color(0, 0, 0, 160));
        image.fillRect(0, 0, WIDTH, HEIGHT);
        image.setColor(new Color(255, 255, 255, 100));
        image.fillRect(5, 5, WIDTH - 10, HEIGHT - 10);

        Font font = image.getFont();
        font = font.deriveFont(FONT_SIZE);
        image.setFont(font);
        image.setColor(Color.WHITE);
        image.drawString(title, WIDTH / 6, HEIGHT / 3);
        image.drawString(prefix + score, WIDTH / 6, (2 * HEIGHT) / 3);
        setImage(image);
    }
}
