import theater.Stage;


/**
 * represents a T tetromino
 *
 * @author Dietrich Boles (University of Oldenburg, Germany)
 * @version 1.0 (17.12.2008)
 *
 */
public class TTetromino extends Tetromino {
    TTetromino() {
        super("brown");
    }

    public void addedToStage(Stage stage) {
        direction = genDirection();

        int start = genStartX();
        getStage().add(b[0], start + 1, 0);
        getStage().add(b[1], start, 1);
        getStage().add(b[2], start + 1, 1);
        getStage().add(b[3], start + 2, 1);
        setDirection();
    }

    protected void setDirection() {
        switch (direction) {
        case NORTH:
            b[0].setLocation(b[2].getColumn(), b[2].getRow() - 1);
            b[1].setLocation(b[2].getColumn() - 1, b[2].getRow());
            b[3].setLocation(b[2].getColumn() + 1, b[2].getRow());

            break;

        case WEST:
            b[0].setLocation(b[2].getColumn() - 1, b[2].getRow());
            b[1].setLocation(b[2].getColumn(), b[2].getRow() + 1);
            b[3].setLocation(b[2].getColumn(), b[2].getRow() - 1);

            break;

        case SOUTH:
            b[0].setLocation(b[2].getColumn(), b[2].getRow() + 1);
            b[1].setLocation(b[2].getColumn() + 1, b[2].getRow());
            b[3].setLocation(b[2].getColumn() - 1, b[2].getRow());

            break;

        case EAST:
            b[0].setLocation(b[2].getColumn() + 1, b[2].getRow());
            b[1].setLocation(b[2].getColumn(), b[2].getRow() - 1);
            b[3].setLocation(b[2].getColumn(), b[2].getRow() + 1);

            break;
        }
    }

    protected Block leftMost() {
        switch (direction) {
        case NORTH:
            return b[1];

        case WEST:
            return b[0];

        case SOUTH:
            return b[3];

        default: // case EAST:

            return b[2];
        }
    }

    protected Block rightMost() {
        switch (direction) {
        case NORTH:
            return b[3];

        case WEST:
            return b[2];

        case SOUTH:
            return b[1];

        default: // case EAST:

            return b[0];
        }
    }

    protected boolean turnPossible() {
        TetrisWorld world = TetrisWorld.getWorld();

        switch (direction) {
        case NORTH:
            return b[2].getRow() < (world.getNumberOfRows() - 3);

        case WEST:
            return b[2].getColumn() < (world.getNumberOfColumns() - 1);

        case SOUTH:
            return true;

        default: // case EAST:

            return b[2].getColumn() >= 1;
        }
    }

    protected int genStartX() {
        return (int) (Math.random() * (TetrisWorld.getWorld()
                                                  .getNumberOfColumns() - 2));
    }
}
