import theater.Stage;


/**
 * represents a Z tetromino
 *
 * @author Dietrich Boles (University of Oldenburg, Germany)
 * @version 1.0 (17.12.2008)
 *
 */
public class ZTetromino extends Tetromino {
    ZTetromino() {
        super("cyan");
    }

    public void addedToStage(Stage stage) {
        direction = genDirection();

        int start = genStartX();
        getStage().add(b[0], start, 1);
        getStage().add(b[1], start + 1, 1);
        getStage().add(b[2], start + 1, 2);
        getStage().add(b[3], start + 2, 2);
        setDirection();
    }

    protected void setDirection() {
        switch (direction) {
        case NORTH:
        case SOUTH:
            b[0].setLocation(b[1].getColumn() - 1, b[1].getRow());
            b[2].setLocation(b[1].getColumn(), b[1].getRow() + 1);
            b[3].setLocation(b[1].getColumn() + 1, b[1].getRow() + 1);

            break;

        case WEST:
        case EAST:
            b[0].setLocation(b[1].getColumn(), b[1].getRow() - 1);
            b[2].setLocation(b[1].getColumn() - 1, b[1].getRow());
            b[3].setLocation(b[1].getColumn() - 1, b[1].getRow() + 1);

            break;
        }
    }

    protected Block leftMost() {
        switch (direction) {
        case NORTH:
        case SOUTH:
            return b[0];

        default: // WEST, EAST

            return b[2];
        }
    }

    protected Block rightMost() {
        switch (direction) {
        case NORTH:
        case SOUTH:
            return b[3];

        default: // WEST, EAST

            return b[1];
        }
    }

    protected boolean turnPossible() {
        TetrisWorld world = TetrisWorld.getWorld();

        switch (direction) {
        case NORTH:
        case SOUTH:
            return b[2].getRow() < (world.getNumberOfRows() - 3);

        default: // WEST, EAST

            return b[1].getColumn() < (world.getNumberOfColumns() - 1);
        }
    }

    protected int genStartX() {
        return (int) (Math.random() * (TetrisWorld.getWorld()
                                                  .getNumberOfColumns() - 2));
    }
}
